package com.xforceplus.security.utils;

import com.google.common.net.InternetDomainName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseCookie;
import java.time.Duration;

/**
 * @author geewit
 */
public class CookieUtils {
    private final static Logger logger = LoggerFactory.getLogger(CookieUtils.class);

    public static ResponseCookie buildCookie(String key, String value, Duration duration, String domain, boolean isTopDomain) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from(key, value).path("/");
        String host;
        String[] hostAndPort = StringUtils.split(domain, ":");
        if (hostAndPort.length == 1) {
            host = domain;
        } else {
            host = hostAndPort[0];
        }
        if(isTopDomain) {
            try {
                host = InternetDomainName.from(host).topPrivateDomain().toString();
            } catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        ResponseCookie cookie = builder.maxAge(duration).domain(host).build();
        return cookie;
    }

}
