package com.xforceplus.utils;

import io.geewit.utils.uuid.UUIDUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

import javax.servlet.http.HttpServletRequest;
import java.io.*;

@SuppressWarnings("all")
@Slf4j
public class BasePathUtils {
    public static String ensureFilePath(HttpServletRequest request) {
        String basePath = request.getServletContext().getRealPath("basepath");
        File baseFile = new File(basePath);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        return basePath + "/" + UUIDUtils.randomUUID() + ".xlsx";
    }


    public static String getTemplatePath(HttpServletRequest request, String filename) {
        String filePath = ensureFilePath(request);
        ClassPathResource resource = new ClassPathResource("template/" + filename);
        try (OutputStream os = new FileOutputStream(filePath);) {
            InputStream is = resource.getInputStream();
            IOUtils.copy(is, os);
            return filePath;
        } catch (IOException e) {
            log.error("getTemplatePath first", e);
        }
        return null;
    }

    public static String getTemplatePath(HttpServletRequest request, String path, String filename) {
        String filePath = ensureFilePath(request);
        ClassPathResource resource = new ClassPathResource(path + "/" + filename);
        try (OutputStream os = new FileOutputStream(filePath)) {
            InputStream is = resource.getInputStream();
            IOUtils.copy(is, os);
            return filePath;
        } catch (IOException e) {
            log.error("getTemplatePath second", e);
        }
        return null;
    }
}
