package com.xforceplus.utils;

import com.xforceplus.config.ImportExportThreadPool;
import org.apache.commons.collections4.ListUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

/**
 * 将导入导出通用的批处理方法抽取出来，避免大量重复代码
 *
 * @author chenpengpeng@xforceplus.com
 * @date 2021/12/6
 **/
public class BatchUtils {
    private BatchUtils(){}

    public static <T> CompletableFuture<Void> doBatchAsync(List<T> dataList, Consumer<List<T>> consumer) {
        List<CompletableFuture<Void>> futureList = new ArrayList<>();
        int partitionSize = dataList.size() > ImportExportThreadPool.CORE_POOL_SIZE ? dataList.size() / ImportExportThreadPool.CORE_POOL_SIZE : 1;
        List<List<T>> splitList = ListUtils.partition(dataList, partitionSize);
        splitList.forEach(item -> futureList.add(CompletableFuture.runAsync(()->consumer.accept(item), ImportExportThreadPool.get())));
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[]{}));
    }
}
