package com.xforceplus.utils;

import com.google.api.client.util.Lists;
import com.google.common.hash.Hashing;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@SuppressWarnings("all")
@Slf4j
public class DidiSignUtils {
    private static String signKey = "PYT_#";

    public static boolean isRegal(Map<String, String> data, String sign) throws NoSuchAlgorithmException {
        if (data == null || data.isEmpty()) {
            return false;
        }
        Set<String> keys = data.keySet();
        ArrayList<String> keyList = Lists.newArrayList(keys);
        keyList.sort(new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return StringUtils.compare(o1, o2);
            }
        });
        String originStr = "";
        for (int i = 0; i < keyList.size(); i++) {
            String key = keyList.get(i);
            String value = data.get(key);
            originStr += (key + "=" + value);
            if (i < keyList.size() - 1) {
                originStr += "&";
            }
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] md5AuthCode = md.digest(signKey.getBytes(StandardCharsets.UTF_8));
        String generatedSign = Hashing.hmacSha256(md5AuthCode)
                .hashBytes(originStr.getBytes(StandardCharsets.UTF_8)).toString().toUpperCase();
        if (StringUtils.isNotBlank(sign)) {
            sign = sign.trim();
        }
//        log.info("generatedSign=={}, sign=={}", generatedSign, sign);
        return StringUtils.equals(generatedSign, sign);
    }

}
