package com.xforceplus.utils;

import com.google.common.net.MediaType;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.*;

@SuppressWarnings("all")
public class DownloadUtils {
    private final static Logger logger = LoggerFactory.getLogger(DownloadUtils.class);

    public static void fileToDownload(HttpServletResponse response, String filePath, String filename) {
        try (InputStream inputStream = new FileInputStream(new File(filePath));) {
            response.setContentType(MediaType.MICROSOFT_EXCEL.toString());
            OutputStream out = response.getOutputStream();
            String myFilename = "resourceImport.xlsx";
            if (StringUtils.isNotBlank(filename)) {
                myFilename = filename;
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + myFilename);
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            inputStream.close();
            out.close();
            out.flush();
        } catch (IOException e) {
            logger.error("fileToDownload fail", e);
            throw new UnknownException("下载文件失败。");
        }
    }

}
