package com.xforceplus.utils;

import io.geewit.web.utils.JsonUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.persistence.Basic;
import javax.persistence.Column;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建时间: 2020/12/3 20:44
 * 功能描述:
 * 修改历史:
 * @author duanhy
 */
public class EntityHelp {

    static Logger logger = LoggerFactory.getLogger(EntityHelp.class);

    public static <T> Map<String, Object> compareObject(T oldData, T newData) {
        Map<String, Object> map = new HashMap<>();
        try {
            Class<?> doClass = oldData.getClass();
            Method[] methods = doClass.getMethods();
            AccessibleObject.setAccessible(methods, true);

            for (Method method : methods) {
                Column column = method.getAnnotation(Column.class);
                Basic basic = method.getAnnotation(Basic.class);
                if (null != column && null != basic) {
                    if (method.getName().startsWith("get")) {
                        String valueOld = StringHelp.safeToString(method.invoke(oldData));
                        String valueNew = StringHelp.safeToString(method.invoke(newData));
                        if (!StringUtils.equalsIgnoreCase(valueOld, valueNew)) {
                            String dataChange = valueOld + "==>" + valueNew;
                            String desString = column.name();
                            map.put(desString, dataChange);
                        }
                    }
                }
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("CompareObject error,oldData:"+ JsonUtils.toJson(oldData) +",newData"+ JsonUtils.toJson(newData));
        }
        return map;
    }

    public static Field[] getBeanFields(Class cls, Field[] fs) {
        fs = ArrayUtils.addAll(fs, cls.getDeclaredFields());
        if (cls.getSuperclass() != null) {
            Class clsSup = cls.getSuperclass();
            fs = getBeanFields(clsSup, fs);
        }

        return fs;
    }

}
