package com.xforceplus.utils;

import javax.servlet.http.HttpServletRequest;

/**
 * @author chenpengpeng
 */
public class IpUtils {
    private static final String UNKNOWN = "unknown";
    public static final String SEPARATOR = ",";

    private IpUtils() {
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Original-Forwarded-For");
        if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) {
            // 多次反向代理后会有多个ip值，第一个ip才是真实ip
            if (ip.contains(SEPARATOR)) {
                ip = ip.split(SEPARATOR)[0];
            }
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("RemoteIp");
        }

        if (isUnknownIp(ip)) {
            ip = request.getHeader("X-Forwarded-For");
            if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) {
                // 多次反向代理后会有多个ip值，第一个ip才是真实ip
                if (ip.contains(SEPARATOR)) {
                    ip = ip.split(SEPARATOR)[0];
                }
            }
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (isUnknownIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (isUnknownIp(ip)) {
            ip = request.getRemoteAddr();
        }

        if (ip == null) {
            ip = UNKNOWN;
        }

        return ip.replaceAll(":", ".");
    }

    /**
     * 是否unknown ip
     *
     * @param ip
     * @return
     */
    private static boolean isUnknownIp(String ip) {
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }
}
