package com.xforceplus.utils;

import com.xforceplus.tenant.security.core.domain.OrgType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2021/1/5 14:22
 * 功能描述: 虚拟组织树帮助类
 * 修改历史:
 */
@SuppressWarnings("all")
public class OrgVirtualNodeUtils {
    private final static Logger logger = LoggerFactory.getLogger(OrgVirtualNodeUtils.class);


    public static Set<Long> findNodeIdInParentIds(String parentIds) {
        String pattern = "(\\d+)" + Arrays.stream(OrgType.values()).map(OrgType::separator).collect(Collectors.joining("|", "[", "]"));
        Matcher matcher = Pattern.compile(pattern).matcher(parentIds);
        Set<Long> parentOrgIds = new HashSet<>();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                Long orgId = Long.parseLong(group);
                parentOrgIds.add(orgId);
            } catch (NumberFormatException e) {
                String message = e.getMessage() + ", value: " + group;
                /**
                 * 添加方法标识 方便定位
                 */
                logger.warn("findNodeIdInParentIds: "+message);
            }
        }
        if (logger.isInfoEnabled()) {
            /**
             * ?
             */
            logger.warn("parentOrgVirtualNodeIds parentOrgIds =  " + parentOrgIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return parentOrgIds;
    }
}
