package com.xforceplus.utils;

import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.util.CollectionUtils;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author geewit
 */
public class RoleUtils {
    /**
     * 计算当前用户是否是管理员和分级管理员角色id集合
     * @param authorizedUser
     * @return
     */
    public static Triple<Boolean, Set<Long>, Set<Long>> calcAdminAndGradingRoles(IAuthorizedUser authorizedUser) {
        Set<IRole> roles = authorizedUser.getRoles();
        boolean isAdmin = false;
        Set<Long> gradingRoleIds = null;
        Set<Long> orgRoleIds = null;
        if (!CollectionUtils.isEmpty(roles)) {
            for (IRole role : roles) {
                if (role.getId() != null) {
                    if (role.getId() == 1) {
                        isAdmin = true;
                        break;
                    } else if (role.getType() != null) {
                        if (role.getType() == 1) {
                            if (gradingRoleIds == null) {
                                gradingRoleIds = Stream.of(role.getId()).collect(Collectors.toSet());
                            } else {
                                gradingRoleIds.add(role.getId());
                            }
                        } else if (role.getType() == 2) {
                            if (orgRoleIds == null) {
                                orgRoleIds = Stream.of(role.getId()).collect(Collectors.toSet());
                            } else {
                                orgRoleIds.add(role.getId());
                            }
                        }
                    }
                }
            }
        }
        return Triple.of(isAdmin, gradingRoleIds, orgRoleIds);
    }
}
