/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: StrUtils.java   2020-12-24 09-29-58
 * Author: Evan
 */
package com.xforceplus.utils;

import com.xforceplus.api.utils.Separator;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>
 * Title: 字符串工具类
 * </p>
 * <p>
 * Description: 字符串工具类
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-24 09-29-58
 * @since V1.0
 */
public final class StrUtils {
    /**
     * 正则表达式提取中文内容-字符串
     */
    public static final String ZH_REGEX = "([\u4e00-\u9fa5]+)";
    /**
     * 正则表达式-提取中文内容
     */
    public static final Pattern ZH_PATTERN = Pattern.compile(ZH_REGEX);

    private StrUtils() {
    }

    /**
     * 提取字符串中的中文字符
     *
     * @param str       字符串
     * @param delimiter 多个中文字符分隔符，如为null，则默认使用" "作为分隔符
     * @return String
     */
    public static String matcherZh(String str, String delimiter) {
        Matcher matcher = ZH_PATTERN.matcher(str);
        if (StringUtils.isEmpty(delimiter)) {
            delimiter = Separator.SPACE;
        }
        StringJoiner joiner = new StringJoiner(delimiter);
        while (matcher.find()) {
            joiner.add(matcher.group());
        }
        return joiner.toString();
    }
}
