package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
public class ExcelFormatUtils {

    private static <T> List<String> check(T t, List<Map> result) {

        List<String> list = new ArrayList<>();
        ReflectionUtils.getAllFields(t.getClass()).forEach(field -> {
            field.setAccessible(true);

            for (int i = 0; i < result.size(); i++) {
                Map<String, String> map = result.get(i);
                String key = field.getName();

                String value = map.get(field.getName());
                if (field.getType() == Integer.class && StringUtils.isNotBlank(value)) {
                    try {
                        Integer.valueOf(value);
                    } catch (Exception e) {
                        list.add("第" + (i + 1) + "行参数格式不正确，参数【" + key + "】值：【" + value + "】");
                    }
                }
            }


        });

        return list;
    }
}
