package com.xforceplus.utils.excel;

import com.google.common.collect.Lists;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.Operator;
import io.geewit.data.jpa.essential.search.SearchFilter;
import org.springframework.data.jpa.domain.Specification;

import java.util.List;

/**
 * @author lengmingzhu
 */
public class QueryUtils {
    public static Object[] list2Array(List idList) {
        if (idList == null) {
            return null;
        }
        if (idList.isEmpty()) {
            return new Object[0];
        }
        Object[] resourcesetIdArray = new Object[idList.size()];
        return idList.toArray(resourcesetIdArray);
    }

    public static Specification getSpecification(String queryField, List idList) {
        Object[] ids = list2Array(idList);
        SearchFilter searchFilter = SearchFilter.build(queryField, Operator.IN, ids);
        Specification specification = DynamicSpecifications.bySearchFilter(Lists.newArrayList(searchFilter));
        return specification;
    }
}
