package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum ResourceEnum {
    //资源码CODE
    resourceCode("resourceCode", "资源码CODE"),
    //资源码名称
    resourceName("resourceName", "资源码名称"),
    //资源码名称
    appId("appId", "产线id"),
    //所属平台
    resourcePlatform("resourcePlatform", "所属平台"),
    //资源码类型
    resourceType("resourceType", "资源码类型"),
    //资源码类型
    isServicePackage("isServicePackage", "是否是服务包"),
    //状态
    status("status", "状态"),
    //父级资源码序号
    parentResourceIndex("parentResourceIndex", "父级资源码序号"),
    //失败原因
    reason("reason", "失败原因");

    public static final String INDEX_TITLE = "序号";

    private static Map<String, ResourceEnum> fieldNameAndEnum = new HashMap<>(8);
    private static Map<String, ResourceEnum> titleAndEnum = new HashMap<>(8);

    static {
        for (ResourceEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            //标题可能包含空格
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);
        }
    }

    private final String fieldName;
    /**
     * 字段标头
     */
    private final String title;

    ResourceEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static ResourceEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static ResourceEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, ResourceEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, ResourceEnum> fieldNameAndEnum) {
        ResourceEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, ResourceEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, ResourceEnum> titleAndEnum) {
        ResourceEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
