package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ResourceExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ResourceExcelUtils.class);


    public static ResourceWrapper extract(String filePath) {
        ResourceWrapper result = new ResourceWrapper();
        ResourceListener excelListener = new ResourceListener();
        ServiceApiListener serviceApiListener = new ServiceApiListener();

        try {
            // 读取部分sheet
            ExcelReader excelReader = EasyExcel.read(filePath).build();
            // 这里为了简单 所以注册了 同样的head 和Listener 自己使用功能必须不同的Listener
            ReadSheet readSheet1 =
                    EasyExcel.readSheet(0).headRowNumber(0).registerReadListener(excelListener).build();
            ReadSheet readSheet2 =
                    EasyExcel.readSheet(1).headRowNumber(0).registerReadListener(serviceApiListener).build();
            // 这里注意 一定要把sheet1 sheet2 一起传进去，不然有个问题就是03版的excel 会读取多次，浪费性能
            excelReader.read(readSheet1, readSheet2);
            // 这里千万别忘记关闭，读的时候会创建临时文件，到时磁盘会崩的
            excelReader.finish();
            //EasyExcelFactory.readBySax(in, new Sheet(1, 0), excelListener);
            //EasyExcelFactory.readBySax(in, new Sheet(2, 0), serviceApiListener);
        } catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException) e.getCause();
            } else {
                throw e;
            }
        }
        List<ResourceExtendDto> list = excelListener.getData();
        List<ServiceApiExtendDto> serviceApiList = serviceApiListener.getData();
        result.setResources(list);
        result.setServiceApis(serviceApiList);
        return result;
    }

    public static void writeV2007(String errorPath, ResourceWrapper wrapper) {
        try {
            ExcelWriter writer = EasyExcel.write(errorPath).build();
            if (CollectionUtils.isNotEmpty(wrapper.getResources())) {
                WriteSheet writeSheet = EasyExcel.writerSheet(1, "资源码导出文件")
                        .head(createListStringHead(wrapper.isSkipReason())).build();
                writer.write(createListObject(wrapper.getResources(), wrapper.isSkipReason()), writeSheet);
            }
            if (CollectionUtils.isNotEmpty(wrapper.getServiceApis())) {
                WriteSheet writeSheet2 = EasyExcel.writerSheet(2, "服务api")
                        .head(createServiceApiHead(wrapper.isSkipReason())).build();
                writer.write(createServiceApiData(wrapper.getServiceApis(), wrapper.isSkipReason()), writeSheet2);
            }
            writer.finish();
        } catch (Exception e) {
            throw new UnknownException("生成文件失败。");
        }
    }

    private static List<List<String>> createListStringHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<List<String>>();
        List<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add(ResourceEnum.INDEX_TITLE);
        head.add(titleHeadColumn);
        ResourceEnum[] enums = ResourceEnum.values();
        for (ResourceEnum item : enums) {
            if (skipReason && item == ResourceEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createServiceApiHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<>();
        ServiceApiEnum[] enums = ServiceApiEnum.values();
        for (ServiceApiEnum item : enums) {
            if (skipReason && item == ServiceApiEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }


    private static List<List<Object>> createListObject(List<ResourceExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ResourceExtendDto resourceExtendDto = list.get(i);
            ResourceEnum[] enums = ResourceEnum.values();
            List<Object> da = new ArrayList<Object>();
            da.add(String.valueOf(i + 1));
            for (ResourceEnum item : enums) {
                if (skipReason && item == ResourceEnum.reason) {
                    continue;
                }
                Class classObj = resourceExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(resourceExtendDto);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("系统异常", e);
                }
            }

            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createServiceApiData(List<ServiceApiExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ServiceApiExtendDto serviceApiExtendDto = list.get(i);
            ServiceApiEnum[] enums = ServiceApiEnum.values();
            List<Object> da = new ArrayList<Object>();
            for (ServiceApiEnum item : enums) {
                if (skipReason && item == ServiceApiEnum.reason) {
                    continue;
                }
                Class classObj = serviceApiExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(serviceApiExtendDto);
                    if (value == null) {
                        value = StringUtils.EMPTY;
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("系统异常", e);
                }
            }

            object.add(da);
        }
        return object;
    }
}
