package com.xforceplus.utils.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
public class ResourceListener extends AnalysisEventListener {
    public static final int IMPORT_LIMIT = 1000;
    private static Logger logger = LoggerFactory.getLogger(ResourceListener.class);
    private List<ResourceExtendDto> data = new ArrayList<ResourceExtendDto>();
    private Map titleList = null;
    private int rowNo = 0;
    private boolean isEnd = false;

    @Override
    public void invoke(Object object, AnalysisContext context) {
        rowNo++;
        Map item = (Map) object;
        if (item == null || item.isEmpty()) {
            return;
        }
        String firstColumn = (String) item.get(0);
        if (titleList == null) {
            //没有找到标题行
            if (firstColumn == null || !StringUtils.equals(firstColumn.trim(), ResourceEnum.INDEX_TITLE)) {   //当前不是标题行
                return;
            }
            titleList = item;
        } else {
            if (isEnd) {
                return;
            }
            if (data.size() >= IMPORT_LIMIT + 1) {
                //最多导入IMPORT_LIMIT + 1行数据
                throw new UnknownException("导入文件内容行数不能超过" + ResourceListener.IMPORT_LIMIT + "行。");
            }
            ResourceExtendDto resourceExtendDto = new ResourceExtendDto();
            Class<? extends ResourceExtendDto> classObj = resourceExtendDto.getClass();
            for (int i = 0; i < titleList.size(); i++) {
                String title = (String) titleList.get(i);
                if (StringUtils.equals(title, ResourceEnum.INDEX_TITLE)) {
                    continue;
                }
                ResourceEnum itineraryCheckEnum = ResourceEnum.getItemByTitle(title);
                if (itineraryCheckEnum == null) {
                    continue;
                }
                Method method = null;
                try {
                    Method[] methods = classObj.getMethods();
                    for (Method oneMethod : methods) {
                        if (StringUtils.equals(oneMethod.getName(), "set" + itineraryCheckEnum.getFieldName().substring(0, 1).toUpperCase() + itineraryCheckEnum.getFieldName().substring(1))) {
                            method = oneMethod;
                        }
                    }
                    if (method == null) {
                        continue;
                    }
                    String value = (String) item.get(i);
                    Object transValue = MyStringUtils.transValue(method.getParameterTypes()[0], value);
                    if (transValue != null) {
                        method.invoke(resourceExtendDto, transValue);
                    }
                } catch (Exception e) {
                    logger.error("ResourceListener invoke", e);
                }
            }

            data.add(resourceExtendDto);
        }

    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<ResourceExtendDto> getData() {
        return data;
    }

    public void setData(List<ResourceExtendDto> data) {
        this.data = data;
    }
}