package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum ResourcesetEnum {
    //产线id
    appId("appId", "产线id"),
    //功能点名称
    resourcesetName("resourcesetName", "功能点名称"),
    //描述
    resourcesetDesc("resourcesetDesc", "描述"),
    //状态
    status("status", "状态"),
    //资源码模块序号
    relResourceIndex("relResourceIndex", "资源码模块序号"),
    //失败原因
    reason("reason", "失败原因");

    public static final String INDEX_TITLE = "序号";

    private static Map<String, ResourcesetEnum> fieldNameAndEnum = new HashMap<>(6);
    private static Map<String, ResourcesetEnum> titleAndEnum = new HashMap<>(6);

    static {
        for (ResourcesetEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);   //标题可能包含空格
        }
    }

    private final String fieldName;
    private final String title;     //字段标头

    ResourcesetEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static ResourcesetEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static ResourcesetEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, ResourcesetEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, ResourcesetEnum> fieldNameAndEnum) {
        ResourcesetEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, ResourcesetEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, ResourcesetEnum> titleAndEnum) {
        ResourcesetEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
