package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ResourcesetExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ResourcesetExcelUtils.class);


    public static ResourcesetWrapper extract(String filePath) {
        ResourcesetWrapper result = new ResourcesetWrapper();
        ResourcesetListener resourcesetListener = new ResourcesetListener();
        SimpleResourceListener simpleResourceListener = new SimpleResourceListener();

        try {
            // 读取部分sheet
            ExcelReader excelReader = EasyExcel.read(filePath).build();
            // 这里为了简单 所以注册了 同样的head 和Listener 自己使用功能必须不同的Listener
            ReadSheet readSheet1 =
                    EasyExcel.readSheet(0).headRowNumber(0).registerReadListener(resourcesetListener).build();
            ReadSheet readSheet2 =
                    EasyExcel.readSheet(1).headRowNumber(0).registerReadListener(simpleResourceListener).build();
            // 这里注意 一定要把sheet1 sheet2 一起传进去，不然有个问题就是03版的excel 会读取多次，浪费性能
            excelReader.read(readSheet1, readSheet2);
            // 这里千万别忘记关闭，读的时候会创建临时文件，到时磁盘会崩的
            excelReader.finish();
            //EasyExcelFactory.readBySax(in, new Sheet(1, 0), excelListener);
            //EasyExcelFactory.readBySax(in, new Sheet(2, 0), serviceApiListener);
        } catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException) e.getCause();
            } else {
                throw e;
            }
        }
        List<ResourcesetExtendDto> resourcesetExtendDtoList = resourcesetListener.getData();
        List<ResourceExtendDto> resourceExtendDtoList = simpleResourceListener.getData();
        result.setResourcesets(resourcesetExtendDtoList);
        result.setResources(resourceExtendDtoList);
        return result;
    }

    public static void writeV2007(String errorPath, ResourcesetWrapper wrapper) {
        try {
            ExcelWriter writer = EasyExcel.write(errorPath).build();
            if (CollectionUtils.isNotEmpty(wrapper.getResourcesets())) {
                WriteSheet writeSheet = EasyExcel.writerSheet(1, "功能集导出文件").head(createResourcesetHead(wrapper.isSkipReason())).build();
                writer.write(createResourcesetData(wrapper.getResourcesets(), wrapper.isSkipReason()), writeSheet);
            }
            if (CollectionUtils.isNotEmpty(wrapper.getResources())) {
                WriteSheet writeSheet2 = EasyExcel.writerSheet(2, "资源码导出文件").head(createResourceHead(wrapper.isSkipReason())).build();
                writer.write(createResourceData(wrapper.getResources(), wrapper.isSkipReason()), writeSheet2);
            }
            writer.finish();
        } catch (Exception e) {
            throw new UnknownException("生成文件失败。");
        }


    }

    private static List<List<String>> createResourcesetHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<>();
        List<String> titleHeadColumn = new ArrayList<>();
        titleHeadColumn.add(ResourcesetEnum.INDEX_TITLE);
        head.add(titleHeadColumn);
        ResourcesetEnum[] enums = ResourcesetEnum.values();
        for (ResourcesetEnum item : enums) {
            if (skipReason && item == ResourcesetEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createResourceHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<>();
        List<String> titleHeadColumn = new ArrayList<>();
        titleHeadColumn.add(SimpleResourceEnum.INDEX_TITLE);
        head.add(titleHeadColumn);
        SimpleResourceEnum[] enums = SimpleResourceEnum.values();
        for (SimpleResourceEnum item : enums) {
            if (skipReason && item == SimpleResourceEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }


    private static List<List<Object>> createResourcesetData(List<ResourcesetExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ResourcesetExtendDto resourcesetExtendDto = list.get(i);
            ResourcesetEnum[] enums = ResourcesetEnum.values();
            List<Object> da = new ArrayList<Object>();
            da.add(String.valueOf(i + 1));
            for (ResourcesetEnum item : enums) {
                if (skipReason && item == ResourcesetEnum.reason) {
                    continue;
                }
                Class<?> classObj = resourcesetExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(resourcesetExtendDto);
                    if (value == null) {
                        value = StringUtils.EMPTY;
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("系统异常", e);
                }
            }

            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createResourceData(List<ResourceExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ResourceExtendDto resourceExtendDto = list.get(i);
            SimpleResourceEnum[] enums = SimpleResourceEnum.values();
            List<Object> da = new ArrayList<Object>();
            da.add(String.valueOf(i + 1));
            for (SimpleResourceEnum item : enums) {
                if (skipReason && item == SimpleResourceEnum.reason) {
                    continue;
                }
                Class<?> classObj = resourceExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(resourceExtendDto);
                    if (value == null) {
                        value = StringUtils.EMPTY;
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("系统异常", e);
                }
            }

            object.add(da);
        }
        return object;
    }
}
