package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum ServiceApiEnum {
    //服务path
    serviceApiPath("serviceApiPath", "服务path"),
    //服务url
    serviceApiUrl("serviceApiUrl", "服务url"),
    //请求方法
    requestMethod("requestMethod", "请求方法"),
    //appId
    appId("appId", "appId"),
    //路由id
    routeId("routeId", "路由id"),
    //是否跳过认证鉴权
    skipAuth("skipAuth", "是否跳过认证鉴权"),
    //是否跳过资源码校验
    skipCheck("skipCheck", "是否跳过资源码校验"),
    //名称
    serviceApiName("serviceApiName", "名称"),
    //状态
    status("status", "状态"),
    //关联资源码序号
    relResourceIndex("relResourceIndex", "关联资源码序号"),
    //失败原因
    reason("reason", "失败原因");


    private static Map<String, ServiceApiEnum> fieldNameAndEnum = new HashMap<>(11);
    private static Map<String, ServiceApiEnum> titleAndEnum = new HashMap<>(11);

    static {
        for (ServiceApiEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);   //标题可能包含空格
        }
    }

    private final String fieldName;
    /**
     * 字段头
     */
    private final String title;

    ServiceApiEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static ServiceApiEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static ServiceApiEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, ServiceApiEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, ServiceApiEnum> fieldNameAndEnum) {
        ServiceApiEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, ServiceApiEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, ServiceApiEnum> titleAndEnum) {
        ServiceApiEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
