package com.xforceplus.utils.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import io.geewit.web.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
public class ServiceApiListener extends AnalysisEventListener {
    public static int IMPORT_LIMIT = 5000;
    private static Logger logger = LoggerFactory.getLogger(ServiceApiListener.class);
    private List<ServiceApiExtendDto> data = new ArrayList<>();
    private Map titleList = null;
    private int rowNo = 0;
    private boolean isEnd = false;

    @Override
    public void invoke(Object object, AnalysisContext context) {
        rowNo++;
        Map item = (Map) object;
        if (item == null || item.isEmpty()) {
            return;
        }
        String firstColumn = (String) item.get(0);
        if (titleList == null) {
            //没有找到标题行
            if (firstColumn == null || !StringUtils.equals(firstColumn.trim(), ServiceApiEnum.serviceApiPath.getTitle())) {
                //当前不是标题行
                return;
            }
            titleList = item;
        } else {
            if (isEnd) {
                return;
            }
            if (data.size() >= IMPORT_LIMIT + 1) {
                //最多导入IMPORT_LIMIT + 1行数据
                throw new UnknownException("导入文件内容行数不能超过" + ServiceApiListener.IMPORT_LIMIT + "行。");
            }
            ServiceApiExtendDto serviceApiExtendDto = new ServiceApiExtendDto();
            Class<? extends ServiceApiExtendDto> classObj = serviceApiExtendDto.getClass();
            for (int i = 0; i < titleList.size(); i++) {
                String title = (String) titleList.get(i);
                ServiceApiEnum itineraryCheckEnum = ServiceApiEnum.getItemByTitle(title);
                if (itineraryCheckEnum == null) {
                    continue;
                }
                Method method = null;
                try {
                    Method[] methods = classObj.getMethods();
                    for (Method oneMethod : methods) {
                        if (StringUtils.equals(oneMethod.getName(), "set" + itineraryCheckEnum.getFieldName().substring(0, 1).toUpperCase() + itineraryCheckEnum.getFieldName().substring(1))) {
                            method = oneMethod;
                        }
                    }
                    if (method == null) {
                        continue;
                    }
                    String value = (String) item.get(i);
                    Object transValue = null;
                    if (StringUtils.equals("requestMethod", itineraryCheckEnum.getFieldName())) {
                        if (StringUtils.isNotBlank(value)) {
                            transValue = RequestMethod.valueOf(value);
                        }
                    } else {
                        transValue = MyStringUtils.transValue(method.getParameterTypes()[0], value);
                    }
                    if (transValue != null) {
                        method.invoke(serviceApiExtendDto, transValue);
                    }
                } catch (Exception e) {
                    logger.error("系统异常，title==" + title + "itineraryCheckEnum=={}", JsonUtils.toJson(itineraryCheckEnum), e);
                }
            }
            data.add(serviceApiExtendDto);
        }

    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<ServiceApiExtendDto> getData() {
        return data;
    }

    public void setData(List<ServiceApiExtendDto> data) {
        this.data = data;
    }
}