package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum ServicePackageEnum {
    //产线id
    appId("appId", "产线id"),
    //"服务包名称"
    servicePackageName("servicePackageName", "服务包名称"),
    //描述
    servicePackageDesc("servicePackageDesc", "描述"),
    //状态
    status("status", "状态"),
    //相关资源码
    relResourceCodes("relResourceCodes", "相关资源码"),
    //失败原因
    reason("reason", "失败原因");
    public static final String INDEX_TITLE = "序号";

    private static Map<String, ServicePackageEnum> fieldNameAndEnum = new HashMap<String, ServicePackageEnum>();
    private static Map<String, ServicePackageEnum> titleAndEnum = new HashMap<String, ServicePackageEnum>();

    static {
        for (ServicePackageEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);   //标题可能包含空格
        }
    }

    private final String fieldName;
    private final String title;     //字段标头

    ServicePackageEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static ServicePackageEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static ServicePackageEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, ServicePackageEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, ServicePackageEnum> fieldNameAndEnum) {
        ServicePackageEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, ServicePackageEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, ServicePackageEnum> titleAndEnum) {
        ServicePackageEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
