package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.domain.resource.ServicePackageExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ServicePackageExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ServicePackageExcelUtils.class);


    public static ServicePackageWrapper extract(String filePath) {
        ServicePackageWrapper result = new ServicePackageWrapper();
        ServicePackageListListener servicePackageListListener = new ServicePackageListListener();
        SimpleResourcesetListener simpleResourcesetListener = new SimpleResourcesetListener();

        try {
            // 读取部分sheet
            ExcelReader excelReader = EasyExcel.read(filePath).build();
            // 这里为了简单 所以注册了 同样的head 和Listener 自己使用功能必须不同的Listener
            ReadSheet readSheet1 =
                    EasyExcel.readSheet(0).headRowNumber(0).registerReadListener(servicePackageListListener).build();
            ReadSheet readSheet2 =
                    EasyExcel.readSheet(1).headRowNumber(0).registerReadListener(simpleResourcesetListener).build();
            // 这里注意 一定要把sheet1 sheet2 一起传进去，不然有个问题就是03版的excel 会读取多次，浪费性能
            excelReader.read(readSheet1, readSheet2);
            // 这里千万别忘记关闭，读的时候会创建临时文件，到时磁盘会崩的
            excelReader.finish();
        } catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException) e.getCause();
            } else {
                throw e;
            }
        }
        List<ServicePackageExtendDto> servicePackageExtendDtoList = servicePackageListListener.getData();
        List<ResourcesetExtendDto> resourcesetExtendDtoList = simpleResourcesetListener.getData();
        result.setServicePackages(servicePackageExtendDtoList);
        result.setResourcesets(resourcesetExtendDtoList);
        return result;
    }

    public static void writeV2007(String errorPath, ServicePackageWrapper wrapper) {

        try {
            ExcelWriter writer = EasyExcel.write(errorPath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet(1, "服务包数据").head(createServicePackageHead(wrapper.isSkipReason())).build();
            writer.write(createServicePackageData(wrapper.getServicePackages(), wrapper.isSkipReason()), writeSheet);
            if (CollectionUtils.isNotEmpty(wrapper.getResourcesets())) {
                WriteSheet writeSheet2 = EasyExcel.writerSheet(2, "关联功能集数据").head(createResourcesetHead(wrapper.isSkipReason())).build();
                writer.write(createResourcesetData(wrapper.getResourcesets(), wrapper.isSkipReason()), writeSheet2);
            }

            writer.finish();
        } catch (Exception e) {
            logger.error("writeV2007:", e);
            throw new UnknownException("生成文件失败。");
        }


    }

    private static List<List<String>> createServicePackageHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<List<String>>();
        List<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add(ServicePackageEnum.INDEX_TITLE);
        head.add(titleHeadColumn);
        ServicePackageEnum[] enums = ServicePackageEnum.values();
        for (ServicePackageEnum item : enums) {
            if (skipReason && item == ServicePackageEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createResourcesetHead(boolean skipReason) {
        List<List<String>> head = new ArrayList<List<String>>();
        List<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add(SimpleResourcesetEnum.INDEX_TITLE);
        head.add(titleHeadColumn);
        SimpleResourcesetEnum[] enums = SimpleResourcesetEnum.values();
        for (SimpleResourcesetEnum item : enums) {
            if (skipReason && item == SimpleResourcesetEnum.reason) {
                continue;
            }
            List<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }


    private static List<List<Object>> createServicePackageData(List<ServicePackageExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ServicePackageExtendDto servicePackageExtendDto = list.get(i);
            ServicePackageEnum[] enums = ServicePackageEnum.values();
            List<Object> da = new ArrayList<Object>();
            da.add(String.valueOf(i + 1));
            for (ServicePackageEnum item : enums) {
                if (skipReason && item == ServicePackageEnum.reason) {
                    continue;
                }
                Class classObj = servicePackageExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(servicePackageExtendDto);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("createServicePackageData reflect invoke", e);
                }
            }

            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createResourcesetData(List<ResourcesetExtendDto> list, boolean skipReason) {
        List<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); i++) {
            ResourcesetExtendDto resourcesetExtendDto = list.get(i);
            SimpleResourcesetEnum[] enums = SimpleResourcesetEnum.values();
            List<Object> da = new ArrayList<Object>();
            da.add(String.valueOf(i + 1));
            for (SimpleResourcesetEnum item : enums) {
                if (skipReason && item == SimpleResourcesetEnum.reason) {
                    continue;
                }
                Class classObj = resourcesetExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1));
                    Object value = method.invoke(resourcesetExtendDto);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                } catch (Exception e) {
                    logger.error("createResourcesetData reflect invoke", e);
                }
            }
            object.add(da);
        }
        return object;
    }
}
