package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum SimpleResourceEnum {
    //资源码CODE
    resourceCode("resourceCode", "资源码CODE"),
    //appId
    appId("appId", "appId"),
    //功能集关联序号
    parentResourceIndex("relSetIndex", "功能集关联序号"),
    //失败原因
    reason("reason", "失败原因");
    public static final String INDEX_TITLE = "序号";

    private static Map<String, SimpleResourceEnum> fieldNameAndEnum = new HashMap<>(4);
    private static Map<String, SimpleResourceEnum> titleAndEnum = new HashMap<>(4);

    static {
        for (SimpleResourceEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);   //标题可能包含空格
        }
    }

    private final String fieldName;
    private final String title;     //字段标头

    SimpleResourceEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static SimpleResourceEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static SimpleResourceEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, SimpleResourceEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, SimpleResourceEnum> fieldNameAndEnum) {
        SimpleResourceEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, SimpleResourceEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, SimpleResourceEnum> titleAndEnum) {
        SimpleResourceEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
