package com.xforceplus.utils.excel;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
public enum SimpleResourcesetEnum {
    //功能集名称
    resourcesetName("resourcesetName", "功能集名称"),
    //产线id
    appId("appId", "产线id"),
    //相关功能集模块资源码
    relResourceCode("relResourceCode", "相关功能集模块资源码"),
    //关联服务包序号
    relServicePackageIndex("relServicePackageIndex", "关联服务包序号"),
    //失败原因
    reason("reason", "失败原因");


    public static final String INDEX_TITLE = "序号";

    private static Map<String, SimpleResourcesetEnum> fieldNameAndEnum = new HashMap<>(4);
    private static Map<String, SimpleResourcesetEnum> titleAndEnum = new HashMap<>(4);

    static {
        for (SimpleResourcesetEnum item : values()) {
            fieldNameAndEnum.put(item.getFieldName(), item);
            titleAndEnum.put(item.getTitle().replaceAll(StringUtils.SPACE, StringUtils.EMPTY), item);
            //标题可能包含空格
        }
    }

    private final String fieldName;
    /**
     * 字段标头
     */
    private final String title;

    SimpleResourcesetEnum(String fieldName, String title) {
        this.fieldName = fieldName;
        this.title = title;
    }

    public static SimpleResourcesetEnum getItemByFieldName(String fieldName) {
        return fieldNameAndEnum.get(fieldName);
    }

    public static SimpleResourcesetEnum getItemByTitle(String title) {
        return titleAndEnum.get(title.replaceAll(StringUtils.SPACE, StringUtils.EMPTY));
    }

    public static Map<String, SimpleResourcesetEnum> getFieldNameAndEnum() {
        return fieldNameAndEnum;
    }

    public static void setFieldNameAndEnum(Map<String, SimpleResourcesetEnum> fieldNameAndEnum) {
        SimpleResourcesetEnum.fieldNameAndEnum = fieldNameAndEnum;
    }

    public static Map<String, SimpleResourcesetEnum> getTitleAndEnum() {
        return titleAndEnum;
    }

    public static void setTitleAndEnum(Map<String, SimpleResourcesetEnum> titleAndEnum) {
        SimpleResourcesetEnum.titleAndEnum = titleAndEnum;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getTitle() {
        return title;
    }
}
