package com.xforceplus.utils.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import io.geewit.web.utils.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressWarnings("all")
public class ExcelConvertListener extends AnalysisEventListener {
    private static final String REPLACE_KEY1 = "${";
    private static final String REPLACE_KEY2 = "}";
    private static final String RGEX = "\\$\\{(.*?)}";
    private static Logger logger = LoggerFactory.getLogger(ExcelConvertListener.class);
    private List<Map> data = Lists.newArrayList();
    private String json;
    private List<String> excelHeaders = Lists.newArrayList();

    public ExcelConvertListener() {
    }

    @Override
    public void invoke(Object object, AnalysisContext context) {
        if (CollectionUtils.isEmpty(this.excelHeaders)) {
            this.excelHeaders.addAll((ArrayList) object);
        } else {
            ArrayList<String> values = (ArrayList<String>) object;
            if (values.size() < this.excelHeaders.size()) {
                int size = this.excelHeaders.size() - values.size();

                for (int i = 0; i < size; ++i) {
                    values.add("");
                }
            }

            String tempJson = this.replaceJson(this.json, this.excelHeaders, values);
            if (tempJson.contains("${") && tempJson.contains("}")) {
                logger.info("excelHeaders:{}", this.excelHeaders);
                logger.info("jsonTemplate:{}", this.json);
                logger.error("errorjson:{}", tempJson);
                throw new IllegalArgumentException("convert fail , please check fields " + JsonUtils.toJson(this.getErrorSub(tempJson, "\\$\\{(.*?)}")));
            }

            Map map = JsonUtils.fromJson(tempJson, new TypeReference<Map>() {
            });
            this.data.add(map);
        }

    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        logger.info("doAfterAllAnalysed");
    }

    private String replaceJson(String json, List<String> excelHeaders, ArrayList<String> values) {
        for (int i = 0; i < excelHeaders.size(); ++i) {
            String key = "${" + excelHeaders.get(i).trim() + "}";
            String value = values.get(i) == null ? "" : values.get(i);
            json = json.replace(key, value);
        }

        return json;
    }

    private List<String> getErrorSub(String json, String rgex) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher matcher = pattern.matcher(json);

        ArrayList<String> list;
        byte i;
        for (list = Lists.newArrayList(); matcher.find(); ) {
            i = 1;
            list.add(matcher.group(i));
        }

        return list;
    }

    public List<Map> getData() {
        return this.data;
    }

    public void setData(List<Map> data) {
        this.data = data;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }
}
