package com.xforceplus.utils.filetransfer;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import io.geewit.utils.uuid.UUIDUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.*;

@SuppressWarnings("all")
@Service
@Slf4j
public class FileTransferUtilsService {
    private final static Logger logger = LoggerFactory.getLogger(FileTransferUtilsService.class);

    @Resource
    private StorageFactory storageFactory;

    private Integer expireDay = 3;
    private String appId = "tenant-service";


    /**
     * 上传文件流数据
     *
     * @param is
     * @param tenantId
     * @param userId
     * @return
     * @throws FileNotFoundException
     */
    public Long uploadInputStream(InputStream is, Long tenantId, Long userId) throws FileNotFoundException {

        //logger.info("导入上传用户{},{}", tenantId, userId);
        String fileName = UUIDUtils.randomUUID();
        // 上传文件
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(appId); // 应用ID, 必填
        uploadFileRequest.setExpires(expireDay); // 有效期（3天）
        uploadFileRequest.setFileName(fileName); //要上传的流 的名称
        uploadFileRequest.setPolicy(Policy.PRIVATE_POLICY); // 文件权限模式( Policy.PUBLIC_POLICY 公共权限模式, PRIVATE_POLICY 私有权限模式);    必填
        uploadFileRequest.setTenantId(tenantId); // 租户ID, 必填
        uploadFileRequest.setUserId(userId); // 用户ID, 必填
        uploadFileRequest.setOverwrite(true); // 是否覆盖原文件, 必填
        uploadFileRequest.setInputStream(is);
        uploadFileRequest.setFilePath("/resources");  // 自定义文件路径, 必填
        return storageFactory.uploadByInputStream(uploadFileRequest);
    }

    /**
     * 上传文件流数据
     *
     * @param is
     * @return
     * @throws FileNotFoundException
     */
    public Long uploadInputStream(InputStream is) throws FileNotFoundException {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }

       // logger.info("导入上传用户:tenantId:{},userId:{}", tenantId, userId);
        return uploadInputStream(is, tenantId, userId);
    }

    /**
     * 按租户上传文件
     *
     * @param filePath
     * @param userId
     * @param tenantId
     * @return
     * @throws FileNotFoundException
     */
    public Long upload(String filePath, Long userId, Long tenantId) throws FileNotFoundException {
//        logger.info("导入上传用户:tenantId:{},userId:{}", tenantId, userId);
        File file = new File(filePath);
        InputStream is = new FileInputStream(file);
        String fileName = UUIDUtils.randomUUID();
        // 上传文件
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(appId); // 应用ID, 必填
        uploadFileRequest.setExpires(expireDay); // 有效期（3天）
        uploadFileRequest.setFileName(fileName); //要上传的流 的名称
        uploadFileRequest.setPolicy(Policy.PRIVATE_POLICY); // 文件权限模式( Policy.PUBLIC_POLICY 公共权限模式, PRIVATE_POLICY 私有权限模式);    必填
        uploadFileRequest.setTenantId(tenantId); // 租户ID, 必填
        uploadFileRequest.setUserId(userId); // 用户ID, 必填
        uploadFileRequest.setOverwrite(true); // 是否覆盖原文件, 必填
        uploadFileRequest.setInputStream(is);
        uploadFileRequest.setFilePath("/resources");  // 自定义文件路径, 必填
        return storageFactory.uploadByInputStream(uploadFileRequest);
    }

    /**
     * 按当前租户和用户和文件路径上传文件
     *
     * @param filePath 文件路径
     * @return Long fileId
     * @throws FileNotFoundException
     */
    public Long upload(String filePath) throws FileNotFoundException {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
//        logger.info("导入上传用户{},{}", tenantId, userId);
        return upload(filePath, userId, tenantId);
    }

    /**
     * 按租户和用户ID
     * @param filePath FilePath
     * @param fileId  fileId
     * @param userId userId
     * @param tenantId tenantId
     * @throws IOException
     */
    public void download(String filePath, Long fileId, Long userId, Long tenantId) throws IOException {
//        log.info("tenantId:{},userId:{},fileId:{}", tenantId, userId, fileId);
        InputStream inputStream = storageFactory.downloadInputStream(userId, tenantId, fileId, "re.xlsx");
        byte[] bytes = IOUtils.toByteArray(inputStream);
        FileUtils.writeByteArrayToFile(new File(filePath), bytes, false);
    }

    /**
     * 按当前
     *
     * @param filePath
     * @param fileId
     * @throws IOException
     */
    public void download(String filePath, Long fileId) throws IOException {
        Long tenantId = 0L;
        Long userId = 0L;
        try {
            IAuthorizedUser currentUser = UserInfoHolder.currentUser();
            tenantId = currentUser.getTenantId();
            userId = currentUser.getId();
        } catch (Exception e) {
            logger.warn("FileTransferUtilsService download2", e);
        }
        this.download(filePath, fileId, userId, tenantId);
    }


}
