package com.xforceplus.utils.yaml;

import lombok.extern.slf4j.Slf4j;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

import java.io.FileWriter;
import java.util.Map;

@SuppressWarnings("all")
@Slf4j
public class ResourceYamlUtils {

    public static String writeYmlResource(String path, Map<String, Object> yamlMap) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try {
            FileWriter fw = new FileWriter(path);
            yaml.dump(yamlMap, fw);
            return path;
        } catch (Exception e) {
            log.error("读取资源码结果文件异常", e);
        }
        return null;
    }
}
