package com.xforceplus.tenant.data.auth.aop.client;

import com.xforceplus.tenant.data.auth.grpc.ForObjectGrpc;
import com.xforceplus.tenant.data.auth.grpc.client.ObjectCheckClientGrpc;
import com.xforceplus.tenant.data.domain.check.ObjectAgreementAuthorization;
import com.xforceplus.tenant.data.domain.result.CheckResult;
import com.xforceplus.tenant.data.domain.result.CheckStatus;
import com.xforceplus.tenant.data.rule.object.context.ObjectAgreement;

import javax.annotation.Resource;

/**
 * @author zhouxink
 */
public class GrpcObjectRuleCheckServiceClient implements ObjectRuleCheckServiceClient{

    @Resource
    private ObjectCheckClientGrpc client;

    @Override
    public CheckResult check(ObjectAgreement agreement) {
        if(null == agreement) {
            CheckResult checkResult = new CheckResult(CheckStatus.PASS);
            return checkResult;
        }

        ObjectAgreementAuthorization oaa = new ObjectAgreementAuthorization();
        oaa.setContent(agreement.getContent());
        oaa.setAuthorization(agreement.getAuthorization());
        oaa.setEntityCode(agreement.getEntityCode());
        oaa.setResourceCode(agreement.getResourceCode());

        ForObjectGrpc.ObjectCheckResult objectCheckResult = client.check(oaa);
        CheckResult checkResult = new CheckResult(CheckStatus.getInstance(objectCheckResult.getStatus()));
        checkResult.setMessage(objectCheckResult.getMessage());
        return checkResult;
    }
}
