/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.data.auth.aop.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tenant.data.auth.aop.client.ObjectRuleCheckServiceClient;
import com.xforceplus.tenant.data.domain.authorization.Authorization;
import com.xforceplus.tenant.data.domain.authorization.AuthorizedUser;
import com.xforceplus.tenant.data.domain.context.DataAuth;
import com.xforceplus.tenant.data.domain.context.DataAuthContextHolder;
import com.xforceplus.tenant.data.domain.result.CheckResult;
import com.xforceplus.tenant.data.domain.result.CheckStatus;
import com.xforceplus.tenant.data.rule.object.context.ObjectAgreement;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(name={"uc.data.auth.enabled"}, havingValue="true")
public class AuthorizedDefinitionAspect {
    private static final Logger log = LoggerFactory.getLogger(AuthorizedDefinitionAspect.class);
    @Resource
    ObjectRuleCheckServiceClient objectRuleCheckServiceClient;
    @Value(value="${uc.data.auth.appId:0}")
    private Long appId;
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Around(value="@annotation(authorizedDefinition)")
    public Object around(ProceedingJoinPoint point, AuthorizedDefinition authorizedDefinition) {
        try {
            Object[] args;
            boolean skipAuth;
            boolean bl = skipAuth = !authorizedDefinition.authentication() && !authorizedDefinition.authorization();
            if (skipAuth) {
                Object object = point.proceed();
                return object;
            }
            Object[] resourceCodes = authorizedDefinition.resources();
            if (ArrayUtils.isEmpty((Object[])resourceCodes)) {
                throw new RuntimeException("resource code must be specified!");
            }
            IAuthorizedUser currentUser = UserInfoHolder.get();
            if (null == currentUser) {
                throw new RuntimeException("login required, can not retrieve user info!");
            }
            Set roles = currentUser.getRoles();
            Set roleIds = roles.stream().map(IRole::getId).collect(Collectors.toSet());
            AuthorizedUser user = new AuthorizedUser(currentUser.getId(), currentUser.getUsername(), roleIds);
            user.setAppId(this.appId);
            user.setTenantId(currentUser.getTenantId());
            user.setTaxNums(currentUser.getTaxNums());
            user.setCompanyIds(currentUser.getCompanies());
            Authorization authorization = new Authorization(user);
            if (authorizedDefinition.dataPreAuth() && StringUtils.isNotBlank((CharSequence)authorizedDefinition.dataEntityCode()) && (args = point.getArgs()) != null && args.length > 0) {
                Map<String, Object> map = this.convertMethodParam(point);
                String content = objectMapper.writeValueAsString(map);
                ObjectAgreement objectAgreement = ObjectAgreement.builder().content(content).authorization(authorization).resourceCode((String)resourceCodes[0]).entityCode(authorizedDefinition.dataEntityCode()).build();
                CheckResult checkResult = this.objectRuleCheckServiceClient.check(objectAgreement);
                log.info("objectAgreement  checkResult status:{},message:{}", checkResult.getStatus(), (Object)checkResult.getMessage());
                if (!CheckStatus.PASS.equals((Object)checkResult)) {
                    throw new RuntimeException(checkResult.getMessage());
                }
            }
            if (authorizedDefinition.dataScopeAuth()) {
                DataAuth auth = new DataAuth();
                auth.setRequired(true);
                authorization.setResourceCode((String)resourceCodes[0]);
                auth.setAuthorization(authorization);
                DataAuthContextHolder.setDataAuth((DataAuth)auth);
            }
            Object object = point.proceed();
            return object;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            DataAuthContextHolder.clean();
        }
    }

    protected Map<String, Object> convertMethodParam(ProceedingJoinPoint point) {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        methodSignature.getParameterNames();
        String[] argNames = methodSignature.getParameterNames();
        Class[] parameterTypes = methodSignature.getParameterTypes();
        Object[] args = point.getArgs();
        HashMap<String, Object> map = new HashMap<String, Object>(argNames.length);
        for (int i = 0; i < argNames.length; ++i) {
            Class classType = parameterTypes[i];
            Object arg = args[i];
            if (!classType.isInstance(arg)) continue;
            map.put(argNames[i], arg);
        }
        return map;
    }
}

