/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import java.util.Objects;

public class Alias
implements Item {
    private String name;
    private boolean useAs;

    public Alias(String name) {
        this(name, false);
    }

    public Alias(String name, boolean useAs) {
        this.name = name;
        this.useAs = useAs;
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        if (this.useAs) {
            buff.append(" AS ");
        }
        buff.append(this.name);
        return buff.toString();
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUseAs() {
        return this.useAs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Alias)) {
            return false;
        }
        Alias alias = (Alias)o;
        return this.isUseAs() == alias.isUseAs() && Objects.equals(this.getName(), alias.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isUseAs());
    }

    public String toString() {
        return "Alias{name='" + this.name + '\'' + ", useAs=" + this.useAs + '}';
    }
}

