/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.ConditionOperator;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Condition
implements Item {
    private Item column;
    private ConditionOperator operator;
    private List<Item> values;

    public Condition(Item column, ConditionOperator operator, Item value) {
        this(column, operator, Arrays.asList(value));
    }

    public Condition(Item column, ConditionOperator operator, List<Item> values) {
        this.column = column;
        this.operator = operator;
        this.values = values;
        switch (operator) {
            case BETWEEN: {
                if (values.size() == 2) break;
                throw new IllegalArgumentException("The symbol \"between\" must have two arguments.");
            }
            case IN: {
                break;
            }
            default: {
                if (values.size() != 0) break;
                throw new IllegalArgumentException(String.format("The symbol(%s) parameter must have an operation target.", operator.getSymbol()));
            }
        }
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    public Item getColumn() {
        return this.column;
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public List<Item> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.getColumn(), condition.getColumn()) && this.getOperator() == condition.getOperator() && Objects.equals(this.getValues(), condition.getValues());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getColumn(), this.getOperator(), this.getValues()});
    }

    public String toString() {
        return "Condition{column=" + this.column + ", operator=" + (Object)((Object)this.operator) + ", values=" + this.values + '}';
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        switch (this.operator) {
            case BETWEEN: {
                buff.append(this.buildLeft()).append(" ").append(this.operator.getSymbol()).append(" ").append(this.values.get(0).toSqlString()).append(" AND ").append(this.values.get(1).toSqlString());
                break;
            }
            case IN: {
                buff.append(this.buildLeft()).append(" ").append(this.operator.getSymbol()).append(" ").append("(");
                for (int i = 0; i < this.values.size(); ++i) {
                    if (i > 0) {
                        buff.append(",");
                    }
                    buff.append(this.values.get(i).toSqlString());
                }
                buff.append(")");
                break;
            }
            default: {
                buff.append(this.buildLeft()).append(" ").append(this.operator.getSymbol()).append(" ").append(this.values.get(0).toSqlString());
            }
        }
        return buff.toString();
    }

    private String buildLeft() {
        return this.column.toSqlString();
    }
}

