/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.define;

import com.xforceplus.tenant.sql.parser.define.Alias;
import com.xforceplus.tenant.sql.parser.define.Aliasable;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.ItemVisitor;
import java.util.Objects;

public class From
extends Aliasable
implements Item {
    private boolean sub = false;
    private String table;

    public From(String table) {
        this(table, null, false);
    }

    public From(String table, Alias alias) {
        this(table, alias, false);
    }

    public From(String table, Alias alias, boolean sub) {
        super(alias);
        this.sub = sub;
        this.table = table;
    }

    public boolean isSub() {
        return this.sub;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public void visit(ItemVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof From)) {
            return false;
        }
        From from = (From)o;
        return this.isSub() == from.isSub() && Objects.equals(this.getTable(), from.getTable()) && Objects.equals(this.getAlias(), from.getAlias());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isSub(), this.getTable(), this.getAlias());
    }

    @Override
    public String toString() {
        return "From{sub=" + this.sub + ", table='" + this.table + '\'' + ", alias='" + (this.hasAlias() ? this.getAlias() : "null") + '\'' + '}';
    }

    @Override
    public String toSqlString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.table);
        if (this.hasAlias()) {
            buff.append(this.getAlias().toSqlString());
        }
        return buff.toString();
    }
}

