/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser;

import com.xforceplus.tenant.sql.parser.Sql;
import com.xforceplus.tenant.sql.parser.define.SqlType;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.JSubSelectSqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.SqlProcessor;
import com.xforceplus.tenant.sql.parser.processor.SqlProcessorVisitor;
import java.util.Objects;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class JSubSql
implements Sql {
    private PlainSelect subSelect;
    private JSubSelectSqlProcessor subSelectSqlProcessor;

    public JSubSql(PlainSelect subSelect) {
        this.subSelect = subSelect;
    }

    @Override
    public SqlProcessor buildProcessor() {
        if (this.subSelectSqlProcessor == null) {
            this.subSelectSqlProcessor = new JSubSelectSqlProcessor(this.subSelect);
        }
        return this.subSelectSqlProcessor;
    }

    @Override
    public void visit(SqlProcessorVisitor visitor) {
        SqlProcessor processor = this.buildProcessor();
        visitor.visit((JSubSelectSqlProcessor)processor);
    }

    @Override
    public SqlType type() {
        return SqlType.SELECT;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    @Override
    public boolean isSub() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSubSql)) {
            return false;
        }
        JSubSql jSubSql = (JSubSql)o;
        return Objects.equals(this.subSelect, jSubSql.subSelect);
    }

    public int hashCode() {
        return Objects.hash(this.subSelect);
    }

    public String toString() {
        return "JSubSql{select=" + this.subSelect + '}';
    }

    @Override
    public String toSqlString() {
        return this.subSelect.toString();
    }

    public static void main(String[] args) throws Exception {
        String sql = "select * from t1 where c1=? and c2=?";
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        System.out.println(statement);
    }
}

