/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.FieldFromAbility;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;

public class JSqlParserDeleteFieldFromAbility
extends AbstractJSqlParserHandler
implements FieldFromAbility {
    public JSqlParserDeleteFieldFromAbility(Statement statement) {
        super(statement, Delete.class);
    }

    @Override
    public List<Map.Entry<Field, From>> searchRealTableName(Item item) throws ProcessorException {
        return this.searchRealTableName((Field)item);
    }

    private List<Map.Entry<Field, From>> searchRealTableName(Field field) {
        Expression where = this.getDelete().getWhere();
        if (where == null) {
            return Collections.emptyList();
        }
        if (this.exists(field, where)) {
            return Arrays.asList(new AbstractMap.SimpleEntry<Field, From>(field, ConversionHelper.convert(this.getDelete().getTable())));
        }
        return Collections.emptyList();
    }

    private boolean exists(Field field, Expression expr) {
        if (BinaryExpression.class.isInstance(expr)) {
            boolean result = this.exists(field, ((BinaryExpression)expr).getLeftExpression());
            if (!result) {
                result = this.exists(field, ((BinaryExpression)expr).getRightExpression());
            }
            return result;
        }
        if (ComparisonOperator.class.isInstance(expr)) {
            return this.exists(field, ((ComparisonOperator)expr).getLeftExpression());
        }
        if (Column.class.isInstance(expr)) {
            return expr.toString().equals(field.toSqlString());
        }
        return false;
    }
}

