/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.Func;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ConversionHelper;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.SelectItemAbility;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;

public class JSqlParserSelectItemAbility
extends AbstractJSqlParserHandler
implements SelectItemAbility {
    public JSqlParserSelectItemAbility(PlainSelect plainSelect) {
        super(plainSelect);
    }

    public JSqlParserSelectItemAbility(Statement statement) {
        super(statement, Select.class);
    }

    @Override
    public void remove(Func func) throws ProcessorException {
        this.doRemove(func);
    }

    @Override
    public void remove(Field field) throws ProcessorException {
        this.doRemove(field);
    }

    private void doRemove(Item item) {
        String sqlString = item.toSqlString();
        if (this.isSubSelect()) {
            this.getSubSelect().accept((SelectVisitor)new RemoveSelectVisitorImpl(sqlString));
        } else {
            SelectBody selectBody = this.getSelect().getSelectBody();
            selectBody.accept((SelectVisitor)new RemoveSelectVisitorImpl(sqlString));
        }
    }

    @Override
    public List<Item> list() throws ProcessorException {
        ArrayList<Item> selectFields = new ArrayList<Item>();
        if (this.isSubSelect()) {
            this.getSubSelect().accept((SelectVisitor)new ListSelectVisitorImpl(selectFields));
        } else {
            SelectBody selectBody = this.getSelect().getSelectBody();
            selectBody.accept((SelectVisitor)new ListSelectVisitorImpl(selectFields));
        }
        return selectFields;
    }

    private static class RemoveSelectVisitorImpl
    extends SelectVisitorAdapter {
        private String targetFieldSql;

        public RemoveSelectVisitorImpl(String targetFieldSql) {
            this.targetFieldSql = targetFieldSql;
        }

        public void visit(PlainSelect plainSelect) {
            List selectItems = plainSelect.getSelectItems();
            if (selectItems != null) {
                List newSelectItems = selectItems.stream().filter(s -> !s.toString().equals(this.targetFieldSql)).collect(Collectors.toList());
                plainSelect.setSelectItems(newSelectItems);
            }
        }

        public void visit(SetOperationList setOpList) {
            boolean first = false;
            this.visit((PlainSelect)setOpList.getSelects().get(0));
        }
    }

    private static class ListSelectVisitorImpl
    extends SelectVisitorAdapter {
        private List<Item> selectFields;

        public ListSelectVisitorImpl(List<Item> selectFields) {
            this.selectFields = selectFields;
        }

        public void visit(SetOperationList setOpList) {
            SelectBody body = (SelectBody)setOpList.getSelects().get(0);
            body.accept((SelectVisitor)new ListSelectVisitorImpl(this.selectFields));
        }

        public void visit(PlainSelect plainSelect) {
            List items = plainSelect.getSelectItems();
            if (items == null) {
                return;
            }
            for (SelectItem item : items) {
                item.accept((SelectItemVisitor)new SelectItemVisitorAdapter(){

                    public void visit(AllColumns columns) {
                        selectFields.add(Field.getAllField());
                    }

                    public void visit(SelectExpressionItem item) {
                        Alias alias = item.getAlias() != null ? item.getAlias() : null;
                        selectFields.add(ConversionHelper.convertSmart(item.getExpression(), alias));
                    }
                });
            }
        }
    }
}

