/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability;

import com.xforceplus.tenant.sql.parser.Sql;
import com.xforceplus.tenant.sql.parser.jsqlparser.JSubSql;
import com.xforceplus.tenant.sql.parser.jsqlparser.processor.ability.AbstractJSqlParserHandler;
import com.xforceplus.tenant.sql.parser.processor.ProcessorException;
import com.xforceplus.tenant.sql.parser.processor.ability.SubSqlAbility;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;

public class JSqlParserSubSqlAbility
extends AbstractJSqlParserHandler
implements SubSqlAbility {
    public JSqlParserSubSqlAbility(Statement statement) {
        super(statement);
    }

    public JSqlParserSubSqlAbility(PlainSelect plainSelect) {
        super(plainSelect);
    }

    @Override
    public List<Sql> list() throws ProcessorException {
        final ArrayList<Sql> subSqlPool = new ArrayList<Sql>();
        if (this.isSubSelect()) {
            this.getSubSelect().accept((SelectVisitor)new ListSelectVisitorImpl(subSqlPool));
        } else if (this.isSelect()) {
            this.doSelect(this.getSelect().getSelectBody(), subSqlPool);
        } else if (this.isUpdate()) {
            this.getUpdate().getStartJoins().stream().forEach(join -> join.getRightItem().accept((FromItemVisitor)new FromItemVisitorAdapter(){

                public void visit(SubSelect subSelect) {
                    JSqlParserSubSqlAbility.this.doSelect(subSelect.getSelectBody(), subSqlPool);
                }
            }));
            JSqlParserSubSqlAbility.doSubWhere(subSqlPool, this.getUpdate().getWhere());
        } else if (this.isDelete()) {
            JSqlParserSubSqlAbility.doSubWhere(subSqlPool, this.getDelete().getWhere());
        }
        return subSqlPool;
    }

    private void doSelect(SelectBody selectBody, List<Sql> subSqlPool) {
        selectBody.accept((SelectVisitor)new ListSelectVisitorImpl(subSqlPool));
    }

    private static void doSubWhere(final List<Sql> subSqlPool, Expression where) {
        if (where == null) {
            return;
        }
        where.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(EqualsTo expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(GreaterThan expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(GreaterThanEquals expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(MinorThan expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(MinorThanEquals expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(NotEqualsTo expr) {
                JSqlParserSubSqlAbility.doProcessComparisonOperator(subSqlPool, (ComparisonOperator)expr);
            }

            public void visit(ExistsExpression expr) {
                if (SubSelect.class.isInstance(expr.getRightExpression())) {
                    JSqlParserSubSqlAbility.doAddPlainSelect(subSqlPool, (SubSelect)expr.getRightExpression());
                }
            }

            public void visit(InExpression expr) {
                if (SubSelect.class.isInstance(expr.getRightItemsList())) {
                    JSqlParserSubSqlAbility.doAddPlainSelect(subSqlPool, (SubSelect)expr.getRightItemsList());
                }
            }

            public void visit(AnyComparisonExpression expr) {
                JSqlParserSubSqlAbility.doAddPlainSelect(subSqlPool, expr.getSubSelect());
            }
        });
    }

    private static void doSubSetOperatorList(List<Sql> subSqls, SetOperationList setOpList) {
        List bodyList = setOpList.getSelects();
        for (int i = 0; i < bodyList.size(); ++i) {
            subSqls.add(new JSubSql((PlainSelect)bodyList.get(i)));
        }
    }

    private static void doSubJoins(final List<Sql> subSqls, List<Join> joins) {
        if (joins != null) {
            for (Join join : joins) {
                join.getRightItem().accept((FromItemVisitor)new FromItemVisitorAdapter(){

                    public void visit(SubSelect subSelect) {
                        JSqlParserSubSqlAbility.doAddPlainSelect(subSqls, subSelect);
                    }
                });
            }
        }
    }

    private static void doSubFromItem(final List<Sql> subSqls, FromItem fromItem) {
        if (fromItem != null) {
            fromItem.accept((FromItemVisitor)new FromItemVisitorAdapter(){

                public void visit(SubSelect subSelect) {
                    JSqlParserSubSqlAbility.doAddPlainSelect(subSqls, subSelect);
                }
            });
        }
    }

    private static void doProcessComparisonOperator(List<Sql> subs, ComparisonOperator expr) {
        if (AnyComparisonExpression.class.isInstance(expr.getRightExpression())) {
            AnyComparisonExpression any = (AnyComparisonExpression)expr.getRightExpression();
            JSqlParserSubSqlAbility.doAddPlainSelect(subs, any.getSubSelect());
        }
    }

    private static void doAddPlainSelect(final List<Sql> subSqls, SubSelect subSelect) {
        subSelect.getSelectBody().accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                subSqls.add(new JSubSql(plainSelect));
            }

            public void visit(SetOperationList setOpList) {
                List selectBodyList = setOpList.getSelects();
                for (SelectBody opBody : selectBodyList) {
                    subSqls.add(new JSubSql((PlainSelect)opBody));
                }
            }
        });
    }

    private static class ListSelectVisitorImpl
    extends SelectVisitorAdapter {
        private List<Sql> subSqls;

        public ListSelectVisitorImpl(List<Sql> subSqls) {
            this.subSqls = subSqls;
        }

        public void visit(PlainSelect plainSelect) {
            JSqlParserSubSqlAbility.doSubFromItem(this.subSqls, plainSelect.getFromItem());
            JSqlParserSubSqlAbility.doSubJoins(this.subSqls, plainSelect.getJoins());
            JSqlParserSubSqlAbility.doSubWhere(this.subSqls, plainSelect.getWhere());
        }

        public void visit(SetOperationList setOpList) {
            JSqlParserSubSqlAbility.doSubSetOperatorList(this.subSqls, setOpList);
        }
    }
}

