/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.sql.parser.jsqlparser.utils;

import com.xforceplus.tenant.sql.parser.define.Field;
import com.xforceplus.tenant.sql.parser.define.From;
import com.xforceplus.tenant.sql.parser.define.Func;
import com.xforceplus.tenant.sql.parser.define.Item;
import com.xforceplus.tenant.sql.parser.define.Parentheses;
import com.xforceplus.tenant.sql.parser.define.arithmetic.Arithmeitc;
import com.xforceplus.tenant.sql.parser.define.arithmetic.ArithmeticSymbol;
import com.xforceplus.tenant.sql.parser.define.values.JdbcParameterValue;
import com.xforceplus.tenant.sql.parser.define.values.NullValue;
import com.xforceplus.tenant.sql.parser.define.values.UnknownValue;
import com.xforceplus.tenant.sql.parser.define.values.Value;
import com.xforceplus.tenant.sql.parser.jsqlparser.utils.ValueHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;

public class ConversionHelper {
    private ConversionHelper() {
    }

    public static Arithmeitc convertArithmeitc(Expression expr) {
        return ConversionHelper.convertArithmeitc(expr, null);
    }

    public static Arithmeitc convertArithmeitc(Expression expr, Alias alias) {
        if (ValueHelper.isArithmeticExpr(expr)) {
            BinaryExpression binaryExpression = (BinaryExpression)expr;
            Expression l = binaryExpression.getLeftExpression();
            Expression r = binaryExpression.getRightExpression();
            Item left = ConversionHelper.convertSmart(l);
            Item right = ConversionHelper.convertSmart(r);
            ArithmeticSymbol symbol = ArithmeticSymbol.getInstance(binaryExpression.getStringExpression());
            return new Arithmeitc(left, right, symbol, ConversionHelper.convert(alias));
        }
        return null;
    }

    public static Item convertSmart(Expression expr) {
        return ConversionHelper.convertSmart(expr, null);
    }

    public static Item convertSmart(Expression expr, Alias alias) {
        if (ValueHelper.isArithmeticExpr(expr)) {
            return ConversionHelper.convertArithmeitc(expr, alias);
        }
        if (ValueHelper.isValueExpr(expr)) {
            return ConversionHelper.convertValue(expr);
        }
        if (Column.class.isInstance(expr)) {
            return ConversionHelper.convert((Column)expr, alias);
        }
        if (Function.class.isInstance(expr)) {
            return ConversionHelper.convert((Function)expr, alias);
        }
        if (Table.class.isInstance(expr)) {
            return ConversionHelper.convert((Table)expr);
        }
        if (TimeKeyExpression.class.isInstance(expr)) {
            return new Func(((TimeKeyExpression)expr).getStringValue(), ConversionHelper.convert(alias));
        }
        if (ValueHelper.isParenthesis(expr)) {
            return new Parentheses(ConversionHelper.convertSmart(((Parenthesis)expr).getExpression()), ConversionHelper.convert(alias));
        }
        if (AnyComparisonExpression.class.isInstance(expr)) {
            AnyComparisonExpression any = (AnyComparisonExpression)expr;
            return new Func(any.getAnyType().name(), Arrays.asList(new com.xforceplus.tenant.sql.parser.define.values.StringValue(((AnyComparisonExpression)expr).getSubSelect().getSelectBody().toString())));
        }
        return UnknownValue.getInstance(expr.toString());
    }

    public static Value convertValue(Expression expr) {
        if (ValueHelper.isValueExpr(expr)) {
            if (LongValue.class.isInstance(expr)) {
                return new com.xforceplus.tenant.sql.parser.define.values.LongValue(((LongValue)expr).getValue());
            }
            if (DoubleValue.class.isInstance(expr)) {
                return new com.xforceplus.tenant.sql.parser.define.values.DoubleValue(((DoubleValue)expr).getValue());
            }
            if (StringValue.class.isInstance(expr)) {
                return new com.xforceplus.tenant.sql.parser.define.values.StringValue(((StringValue)expr).getValue());
            }
            if (net.sf.jsqlparser.expression.NullValue.class.isInstance(expr)) {
                return NullValue.getInstance();
            }
            if (JdbcParameter.class.isInstance(expr)) {
                return JdbcParameterValue.geInstance();
            }
        }
        return UnknownValue.getInstance(expr.toString());
    }

    public static Field convert(Column column) {
        return ConversionHelper.convert(column, null);
    }

    public static Field convert(Column column, Alias alias) {
        String tableName = null;
        if (column.getTable() != null) {
            tableName = column.getTable().getName();
        }
        return new Field(tableName, column.getColumnName(), ConversionHelper.convert(alias));
    }

    public static Func convert(TimeKeyExpression expr) {
        return new Func(expr.getStringValue(), null, null);
    }

    public static Func convert(TimeKeyExpression expr, Alias alias) {
        return new Func(expr.getStringValue(), ConversionHelper.convert(alias));
    }

    public static Func convert(Function function) {
        return ConversionHelper.convert(function, null);
    }

    public static Func convert(Function function, Alias alias) {
        ExpressionList parameterList = function.getParameters();
        if (function.isAllColumns()) {
            return new Func(function.getName(), Arrays.asList(new Field("*")), ConversionHelper.convert(alias));
        }
        List parameters = null;
        if (parameterList != null) {
            parameters = parameterList.getExpressions();
        }
        ArrayList<Item> paramItemList = new ArrayList<Item>(parameters.size());
        if (parameters != null && !parameters.isEmpty()) {
            for (Expression expr : parameters) {
                ConversionHelper.conversionFuncParam(paramItemList, expr);
            }
        }
        return new Func(function.getName(), paramItemList, ConversionHelper.convert(alias));
    }

    public static From convert(Table table) {
        if (table == null) {
            return null;
        }
        return new From(table.getName(), ConversionHelper.convert(table.getAlias()));
    }

    public static com.xforceplus.tenant.sql.parser.define.Alias convert(Alias alias) {
        if (alias == null) {
            return null;
        }
        return new com.xforceplus.tenant.sql.parser.define.Alias(alias.getName(), alias.isUseAs());
    }

    private static void conversionFuncParam(List<Item> paramItemList, Expression expr) {
        if (Column.class.isInstance(expr)) {
            paramItemList.add(ConversionHelper.convert((Column)expr));
        } else if (ValueHelper.isValueExpr(expr)) {
            paramItemList.add(ConversionHelper.convertValue(expr));
        }
    }
}

