package com.xforceplus.testapp1.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.testapp1.entity.Application;
import com.xforceplus.testapp1.service.IApplicationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2020-11-09
 */
@RestController
public class ApplicationController {

  @Autowired
  private IApplicationService applicationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param application ${table.comment}
   * @return
   */
  @GetMapping("/applications" )
  public XfR getApplications(XfPage page, Application application) {
    return XfR.ok(applicationServiceImpl.page(page, Wrappers.query(application)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/applications/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(applicationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param application ${table.comment}
   * @return XfR
   */
  @PostMapping("/applications")
  public XfR save(@RequestBody Application application) {
     return XfR.ok(applicationServiceImpl.save(application));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param application ${table.comment}
   * @return XfR
   */
  @PutMapping("/applications/{id}")
  public XfR putUpdate(@RequestBody Application application,@PathVariable Long id) {
      application.setId(id);
      return XfR.ok(applicationServiceImpl.updateById(application));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param application ${table.comment}
   * @return XfR
   */
  @PatchMapping("/applications/{id}")
  public XfR patchUpdate(@RequestBody Application application,@PathVariable Long id) {
      Application upapplication = applicationServiceImpl.getById(id);
      if(upapplication != null){
        upapplication = ObjectCopyUtils.copyProperties(application,upapplication,true);
      }
      return XfR.ok(applicationServiceImpl.updateById(upapplication));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applications/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(applicationServiceImpl.removeById(id));
  }

  @PostMapping("/applications/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "application");
      params.put("request", condition);

     return XfR.ok(applicationServiceImpl.querys(params));
  }

}
