package com.xforceplus.metadata.controller;


/**
 * 应用管理feign客户端
 *
 * @author wangzheng
 * @date 2020-07-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.metadata.entity.Application;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "test-module")
public interface ApplicationFeignApi {

  /**
   * 通过id查询应用管理
   * @param  id
   * @return R
   */
  @GetMapping("/application/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用管理
   * @param application 应用管理
   * @return R
   */
  @PostMapping("/application/add")
  public R save(@RequestBody Application application);

  /**
   * 修改应用管理
   * @param application 应用管理
   * @return R
   */
  @PostMapping("/application/update")
  public R updateById(@RequestBody Application application);

  /**
   * 通过id删除应用管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/application/del/{id}" )
  public R removeById(@PathVariable Long id);

}