package com.xforceplus.testdatarule.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testdatarule.entity.BoDelTest;
import com.xforceplus.testdatarule.service.IBoDelTestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class BoDelTestController {

  @Autowired
  private IBoDelTestService boDelTestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boDelTest ${table.comment}
   * @return
   */
  @GetMapping("/bodeltests" )
  public XfR getBoDelTests(XfPage page, BoDelTest boDelTest) {
    return XfR.ok(boDelTestServiceImpl.page(page, Wrappers.query(boDelTest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bodeltests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boDelTestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param boDelTest ${table.comment}
   * @return XfR
   */
  @PostMapping("/bodeltests")
  public XfR save(@RequestBody BoDelTest boDelTest) {
     return XfR.ok(boDelTestServiceImpl.save(boDelTest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param boDelTest ${table.comment}
   * @return XfR
   */
  @PutMapping("/bodeltests/{id}")
  public XfR putUpdate(@RequestBody BoDelTest boDelTest,@PathVariable Long id) {
      boDelTest.setId(id);
      return XfR.ok(boDelTestServiceImpl.updateById(boDelTest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param boDelTest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bodeltests/{id}")
  public XfR patchUpdate(@RequestBody BoDelTest boDelTest,@PathVariable Long id) {
      BoDelTest upboDelTest = boDelTestServiceImpl.getById(id);
      if(upboDelTest != null){
        upboDelTest = ObjectCopyUtils.copyProperties(boDelTest,upboDelTest,true);
      }
      return XfR.ok(boDelTestServiceImpl.updateById(upboDelTest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bodeltests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boDelTestServiceImpl.removeById(id));
  }

  @PostMapping("/bodeltests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo_del_test");
     params.put("request", condition);

     return XfR.ok(boDelTestServiceImpl.querys(params));
  }

}
