package com.xforceplus.testdatarule.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testdatarule.entity.TestBo2;
import com.xforceplus.testdatarule.service.ITestBo2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class TestBo2Controller {

  @Autowired
  private ITestBo2Service testBo2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testBo2 ${table.comment}
   * @return
   */
  @GetMapping("/testbo2s" )
  public XfR getTestBo2s(XfPage page, TestBo2 testBo2) {
    return XfR.ok(testBo2ServiceImpl.page(page, Wrappers.query(testBo2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbo2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testBo2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testBo2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbo2s")
  public XfR save(@RequestBody TestBo2 testBo2) {
     return XfR.ok(testBo2ServiceImpl.save(testBo2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testBo2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbo2s/{id}")
  public XfR putUpdate(@RequestBody TestBo2 testBo2,@PathVariable Long id) {
      testBo2.setId(id);
      return XfR.ok(testBo2ServiceImpl.updateById(testBo2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testBo2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbo2s/{id}")
  public XfR patchUpdate(@RequestBody TestBo2 testBo2,@PathVariable Long id) {
      TestBo2 uptestBo2 = testBo2ServiceImpl.getById(id);
      if(uptestBo2 != null){
        uptestBo2 = ObjectCopyUtils.copyProperties(testBo2,uptestBo2,true);
      }
      return XfR.ok(testBo2ServiceImpl.updateById(uptestBo2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbo2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testBo2ServiceImpl.removeById(id));
  }

  @PostMapping("/testbo2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_bo2");
     params.put("request", condition);

     return XfR.ok(testBo2ServiceImpl.querys(params));
  }

}
