package com.xforceplus.testdatarule.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testdatarule.entity.TestBo;
import com.xforceplus.testdatarule.service.ITestBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-12
 */
@RestController
public class TestBoController {

  @Autowired
  private ITestBoService testBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testBo ${table.comment}
   * @return
   */
  @GetMapping("/testbos" )
  public XfR getTestBos(XfPage page, TestBo testBo) {
    return XfR.ok(testBoServiceImpl.page(page, Wrappers.query(testBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbos")
  public XfR save(@RequestBody TestBo testBo) {
     return XfR.ok(testBoServiceImpl.save(testBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbos/{id}")
  public XfR putUpdate(@RequestBody TestBo testBo,@PathVariable Long id) {
      testBo.setId(id);
      return XfR.ok(testBoServiceImpl.updateById(testBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbos/{id}")
  public XfR patchUpdate(@RequestBody TestBo testBo,@PathVariable Long id) {
      TestBo uptestBo = testBoServiceImpl.getById(id);
      if(uptestBo != null){
        uptestBo = ObjectCopyUtils.copyProperties(testBo,uptestBo,true);
      }
      return XfR.ok(testBoServiceImpl.updateById(uptestBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testBoServiceImpl.removeById(id));
  }

  @PostMapping("/testbos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_bo");
     params.put("request", condition);

     return XfR.ok(testBoServiceImpl.querys(params));
  }

}
