package com.xforceplus.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.metadata.entity.Department;
import com.xforceplus.metadata.service.IDepartmentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-06
 */
@RestController
public class DepartmentController {

  @Autowired
  private IDepartmentService departmentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param department ${table.comment}
   * @return
   */
  @GetMapping("/departments" )
  public XfR getDepartments(XfPage page, Department department) {
    return XfR.ok(departmentServiceImpl.page(page, Wrappers.query(department)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departmentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param department ${table.comment}
   * @return XfR
   */
  @PostMapping("/departments")
  public XfR save(@RequestBody Department department) {
     return XfR.ok(departmentServiceImpl.save(department));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param department ${table.comment}
   * @return XfR
   */
  @PutMapping("/departments/{id}")
  public XfR putUpdate(@RequestBody Department department,@PathVariable Long id) {
      department.setId(id);
      return XfR.ok(departmentServiceImpl.updateById(department));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param department ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departments/{id}")
  public XfR patchUpdate(@RequestBody Department department,@PathVariable Long id) {
      Department updepartment = departmentServiceImpl.getById(id);
      if(updepartment != null){
        updepartment = ObjectCopyUtils.copyProperties(department,updepartment,true);
      }
      return XfR.ok(departmentServiceImpl.updateById(updepartment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departmentServiceImpl.removeById(id));
  }

}