package com.xforceplus.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.metadata.entity.Employee;
import com.xforceplus.metadata.service.IEmployeeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-06
 */
@RestController
public class EmployeeController {

  @Autowired
  private IEmployeeService employeeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param employee ${table.comment}
   * @return
   */
  @GetMapping("/employees" )
  public XfR getEmployees(XfPage page, Employee employee) {
    return XfR.ok(employeeServiceImpl.page(page, Wrappers.query(employee)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/employees/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(employeeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param employee ${table.comment}
   * @return XfR
   */
  @PostMapping("/employees")
  public XfR save(@RequestBody Employee employee) {
     return XfR.ok(employeeServiceImpl.save(employee));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param employee ${table.comment}
   * @return XfR
   */
  @PutMapping("/employees/{id}")
  public XfR putUpdate(@RequestBody Employee employee,@PathVariable Long id) {
      employee.setId(id);
      return XfR.ok(employeeServiceImpl.updateById(employee));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param employee ${table.comment}
   * @return XfR
   */
  @PatchMapping("/employees/{id}")
  public XfR patchUpdate(@RequestBody Employee employee,@PathVariable Long id) {
      Employee upemployee = employeeServiceImpl.getById(id);
      if(upemployee != null){
        upemployee = ObjectCopyUtils.copyProperties(employee,upemployee,true);
      }
      return XfR.ok(employeeServiceImpl.updateById(upemployee));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/employees/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(employeeServiceImpl.removeById(id));
  }

}