/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultramanbocp.entity.Tenant;
import com.xforceplus.ultramanbocp.service.ITenantService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TenantController {
    @Autowired
    private ITenantService tenantServiceImpl;

    @GetMapping(value={"/tenants"})
    public XfR getTenants(XfPage page, Tenant tenant) {
        return XfR.ok((Object)this.tenantServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)tenant)));
    }

    @GetMapping(value={"/tenants/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.tenantServiceImpl.getById(id));
    }

    @PostMapping(value={"/tenants"})
    public XfR save(@RequestBody Tenant tenant) {
        return XfR.ok((Object)this.tenantServiceImpl.save(tenant));
    }

    @PutMapping(value={"/tenants/{id}"})
    public XfR putUpdate(@RequestBody Tenant tenant, @PathVariable Long id) {
        tenant.setId(id);
        return XfR.ok((Object)this.tenantServiceImpl.updateById(tenant));
    }

    @PatchMapping(value={"/tenants/{id}"})
    public XfR patchUpdate(@RequestBody Tenant tenant, @PathVariable Long id) {
        Tenant uptenant = (Tenant)this.tenantServiceImpl.getById(id);
        if (uptenant != null) {
            uptenant = (Tenant)ObjectCopyUtils.copyProperties((Object)tenant, (Object)uptenant, (boolean)true);
        }
        return XfR.ok((Object)this.tenantServiceImpl.updateById(uptenant));
    }

    @DeleteMapping(value={"/tenants/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.tenantServiceImpl.removeById(id));
    }
}

