package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Elephant;
import com.xforceplus.ultramanbocp.service.IElephantService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-31
 */
@RestController
public class ElephantController {

  @Autowired
  private IElephantService elephantServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param elephant ${table.comment}
   * @return
   */
  @GetMapping("/elephants" )
  public XfR getElephants(XfPage page, Elephant elephant) {
    return XfR.ok(elephantServiceImpl.page(page, Wrappers.query(elephant)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/elephants/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(elephantServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param elephant ${table.comment}
   * @return XfR
   */
  @PostMapping("/elephants")
  public XfR save(@RequestBody Elephant elephant) {
     return XfR.ok(elephantServiceImpl.save(elephant));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param elephant ${table.comment}
   * @return XfR
   */
  @PutMapping("/elephants/{id}")
  public XfR putUpdate(@RequestBody Elephant elephant,@PathVariable Long id) {
      elephant.setId(id);
      return XfR.ok(elephantServiceImpl.updateById(elephant));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param elephant ${table.comment}
   * @return XfR
   */
  @PatchMapping("/elephants/{id}")
  public XfR patchUpdate(@RequestBody Elephant elephant,@PathVariable Long id) {
      Elephant upelephant = elephantServiceImpl.getById(id);
      if(upelephant != null){
        upelephant = ObjectCopyUtils.copyProperties(elephant,upelephant,true);
      }
      return XfR.ok(elephantServiceImpl.updateById(upelephant));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/elephants/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(elephantServiceImpl.removeById(id));
  }

}