package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Message;
import com.xforceplus.ultramanbocp.service.IMessageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-31
 */
@RestController
public class MessageController {

  @Autowired
  private IMessageService messageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param message ${table.comment}
   * @return
   */
  @GetMapping("/messages" )
  public XfR getMessages(XfPage page, Message message) {
    return XfR.ok(messageServiceImpl.page(page, Wrappers.query(message)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/messages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(messageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param message ${table.comment}
   * @return XfR
   */
  @PostMapping("/messages")
  public XfR save(@RequestBody Message message) {
     return XfR.ok(messageServiceImpl.save(message));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param message ${table.comment}
   * @return XfR
   */
  @PutMapping("/messages/{id}")
  public XfR putUpdate(@RequestBody Message message,@PathVariable Long id) {
      message.setId(id);
      return XfR.ok(messageServiceImpl.updateById(message));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param message ${table.comment}
   * @return XfR
   */
  @PatchMapping("/messages/{id}")
  public XfR patchUpdate(@RequestBody Message message,@PathVariable Long id) {
      Message upmessage = messageServiceImpl.getById(id);
      if(upmessage != null){
        upmessage = ObjectCopyUtils.copyProperties(message,upmessage,true);
      }
      return XfR.ok(messageServiceImpl.updateById(upmessage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/messages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(messageServiceImpl.removeById(id));
  }

}