package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Tenant;
import com.xforceplus.ultramanbocp.service.ITenantService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-31
 */
@RestController
public class TenantController {

  @Autowired
  private ITenantService tenantServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenant ${table.comment}
   * @return
   */
  @GetMapping("/tenants" )
  public XfR getTenants(XfPage page, Tenant tenant) {
    return XfR.ok(tenantServiceImpl.page(page, Wrappers.query(tenant)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenants/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenant ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenants")
  public XfR save(@RequestBody Tenant tenant) {
     return XfR.ok(tenantServiceImpl.save(tenant));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenant ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenants/{id}")
  public XfR putUpdate(@RequestBody Tenant tenant,@PathVariable Long id) {
      tenant.setId(id);
      return XfR.ok(tenantServiceImpl.updateById(tenant));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenant ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenants/{id}")
  public XfR patchUpdate(@RequestBody Tenant tenant,@PathVariable Long id) {
      Tenant uptenant = tenantServiceImpl.getById(id);
      if(uptenant != null){
        uptenant = ObjectCopyUtils.copyProperties(tenant,uptenant,true);
      }
      return XfR.ok(tenantServiceImpl.updateById(uptenant));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenants/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantServiceImpl.removeById(id));
  }

}