/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultramanbocp.entity.Employee;
import com.xforceplus.ultramanbocp.service.IEmployeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EmployeeController {
    @Autowired
    private IEmployeeService employeeServiceImpl;

    @GetMapping(value={"/employees"})
    public XfR getEmployees(XfPage page, Employee employee) {
        return XfR.ok((Object)this.employeeServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)employee)));
    }

    @GetMapping(value={"/employees/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.employeeServiceImpl.getById(id));
    }

    @PostMapping(value={"/employees"})
    public XfR save(@RequestBody Employee employee) {
        return XfR.ok((Object)this.employeeServiceImpl.save(employee));
    }

    @PutMapping(value={"/employees/{id}"})
    public XfR putUpdate(@RequestBody Employee employee, @PathVariable Long id) {
        employee.setId(id);
        return XfR.ok((Object)this.employeeServiceImpl.updateById(employee));
    }

    @PatchMapping(value={"/employees/{id}"})
    public XfR patchUpdate(@RequestBody Employee employee, @PathVariable Long id) {
        Employee upemployee = (Employee)this.employeeServiceImpl.getById(id);
        if (upemployee != null) {
            upemployee = (Employee)ObjectCopyUtils.copyProperties((Object)employee, (Object)upemployee, (boolean)true);
        }
        return XfR.ok((Object)this.employeeServiceImpl.updateById(upemployee));
    }

    @DeleteMapping(value={"/employees/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.employeeServiceImpl.removeById(id));
    }
}

