package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.Four0608001;
import com.xforceplus.testoqs202.service.IFour0608001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * four0608001x前端控制器
 *
 * @author ultraman
 * @date 2023-06-08
 */
@RestController
public class Four0608001Controller {

  @Autowired
  private IFour0608001Service four0608001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param four0608001 four0608001x
   * @return
   */
  @GetMapping("/four0608001s" )
  public XfR getFour0608001s(XfPage page, Four0608001 four0608001) {
    return XfR.ok(four0608001ServiceImpl.page(page, Wrappers.query(four0608001)));
  }

  /**
   * 通过id查询four0608001x
   * @param  id
   * @return XfR
   */
  @GetMapping("/four0608001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(four0608001ServiceImpl.getById(id));
  }

  /**
   * 新增four0608001x
   * @param four0608001 four0608001x
   * @return XfR
   */
  @PostMapping("/four0608001s")
  public XfR save(@RequestBody Four0608001 four0608001) {
     return XfR.ok(four0608001ServiceImpl.save(four0608001));
  }

  /**
   * 修改-传入修改后的全部数据four0608001x
   * @param four0608001 four0608001x
   * @return XfR
   */
  @PutMapping("/four0608001s/{id}")
  public XfR putUpdate(@RequestBody Four0608001 four0608001,@PathVariable Long id) {
      four0608001.setId(id);
      return XfR.ok(four0608001ServiceImpl.updateById(four0608001));
  }

  /**
   * 修改-传入修改的数据four0608001x
   * @param four0608001 four0608001x
   * @return XfR
   */
  @PatchMapping("/four0608001s/{id}")
  public XfR patchUpdate(@RequestBody Four0608001 four0608001,@PathVariable Long id) {
      Four0608001 upfour0608001 = four0608001ServiceImpl.getById(id);
      if(upfour0608001 != null){
        upfour0608001 = ObjectCopyUtils.copyProperties(four0608001,upfour0608001,true);
      }
      return XfR.ok(four0608001ServiceImpl.updateById(upfour0608001));
  }

  /**
   * 通过id删除four0608001x
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/four0608001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(four0608001ServiceImpl.removeById(id));
  }

  @PostMapping("/four0608001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "four0608001");
     params.put("request", condition);

     return XfR.ok(four0608001ServiceImpl.querys(params));
  }

}
