package com.xforceplus.testoqs202.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.testoqs202.entity.One0608001;
import com.xforceplus.testoqs202.service.IOne0608001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * one0608001前端控制器
 *
 * @author ultraman
 * @date 2023-06-08
 */
@RestController
public class One0608001Controller {

  @Autowired
  private IOne0608001Service one0608001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0608001 one0608001
   * @return
   */
  @GetMapping("/one0608001s" )
  public XfR getOne0608001s(XfPage page, One0608001 one0608001) {
    return XfR.ok(one0608001ServiceImpl.page(page, Wrappers.query(one0608001)));
  }

  /**
   * 通过id查询one0608001
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0608001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0608001ServiceImpl.getById(id));
  }

  /**
   * 新增one0608001
   * @param one0608001 one0608001
   * @return XfR
   */
  @PostMapping("/one0608001s")
  public XfR save(@RequestBody One0608001 one0608001) {
     return XfR.ok(one0608001ServiceImpl.save(one0608001));
  }

  /**
   * 修改-传入修改后的全部数据one0608001
   * @param one0608001 one0608001
   * @return XfR
   */
  @PutMapping("/one0608001s/{id}")
  public XfR putUpdate(@RequestBody One0608001 one0608001,@PathVariable Long id) {
      one0608001.setId(id);
      return XfR.ok(one0608001ServiceImpl.updateById(one0608001));
  }

  /**
   * 修改-传入修改的数据one0608001
   * @param one0608001 one0608001
   * @return XfR
   */
  @PatchMapping("/one0608001s/{id}")
  public XfR patchUpdate(@RequestBody One0608001 one0608001,@PathVariable Long id) {
      One0608001 upone0608001 = one0608001ServiceImpl.getById(id);
      if(upone0608001 != null){
        upone0608001 = ObjectCopyUtils.copyProperties(one0608001,upone0608001,true);
      }
      return XfR.ok(one0608001ServiceImpl.updateById(upone0608001));
  }

  /**
   * 通过id删除one0608001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0608001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0608001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0608001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0608001");
     params.put("request", condition);

     return XfR.ok(one0608001ServiceImpl.querys(params));
  }

}
